<?php //95d520622de2860d89b46cc51ec09aad
/** @noinspection all */

namespace App\Models {

    use Database\Factories\CustomerFactory;
    use Database\Factories\EmployeeFactory;
    use Database\Factories\kitserviceFactory;
    use Database\Factories\UserFactory;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_Address_C;
    use LaravelIdea\Helper\App\Models\_IH_Address_QB;
    use LaravelIdea\Helper\App\Models\_IH_CashOut_C;
    use LaravelIdea\Helper\App\Models\_IH_CashOut_QB;
    use LaravelIdea\Helper\App\Models\_IH_Child_C;
    use LaravelIdea\Helper\App\Models\_IH_Child_QB;
    use LaravelIdea\Helper\App\Models\_IH_clients_C;
    use LaravelIdea\Helper\App\Models\_IH_clients_QB;
    use LaravelIdea\Helper\App\Models\_IH_Customer_C;
    use LaravelIdea\Helper\App\Models\_IH_Customer_QB;
    use LaravelIdea\Helper\App\Models\_IH_department_C;
    use LaravelIdea\Helper\App\Models\_IH_department_QB;
    use LaravelIdea\Helper\App\Models\_IH_echelon_C;
    use LaravelIdea\Helper\App\Models\_IH_echelon_QB;
    use LaravelIdea\Helper\App\Models\_IH_Emergency_C;
    use LaravelIdea\Helper\App\Models\_IH_Emergency_QB;
    use LaravelIdea\Helper\App\Models\_IH_EmployeeEntreprise_C;
    use LaravelIdea\Helper\App\Models\_IH_EmployeeEntreprise_QB;
    use LaravelIdea\Helper\App\Models\_IH_Employee_C;
    use LaravelIdea\Helper\App\Models\_IH_Employee_QB;
    use LaravelIdea\Helper\App\Models\_IH_EndContract_C;
    use LaravelIdea\Helper\App\Models\_IH_EndContract_QB;
    use LaravelIdea\Helper\App\Models\_IH_end_contracts_C;
    use LaravelIdea\Helper\App\Models\_IH_end_contracts_QB;
    use LaravelIdea\Helper\App\Models\_IH_Familly_C;
    use LaravelIdea\Helper\App\Models\_IH_Familly_QB;
    use LaravelIdea\Helper\App\Models\_IH_fonction_C;
    use LaravelIdea\Helper\App\Models\_IH_fonction_QB;
    use LaravelIdea\Helper\App\Models\_IH_Invoice_C;
    use LaravelIdea\Helper\App\Models\_IH_Invoice_QB;
    use LaravelIdea\Helper\App\Models\_IH_items_C;
    use LaravelIdea\Helper\App\Models\_IH_items_QB;
    use LaravelIdea\Helper\App\Models\_IH_kitservice_C;
    use LaravelIdea\Helper\App\Models\_IH_kitservice_QB;
    use LaravelIdea\Helper\App\Models\_IH_niveau_C;
    use LaravelIdea\Helper\App\Models\_IH_niveau_QB;
    use LaravelIdea\Helper\App\Models\_IH_Payroll_C;
    use LaravelIdea\Helper\App\Models\_IH_Payroll_QB;
    use LaravelIdea\Helper\App\Models\_IH_purchase_orders_C;
    use LaravelIdea\Helper\App\Models\_IH_purchase_orders_QB;
    use LaravelIdea\Helper\App\Models\_IH_salary_grid_C;
    use LaravelIdea\Helper\App\Models\_IH_salary_grid_QB;
    use LaravelIdea\Helper\App\Models\_IH_TimeSheet_C;
    use LaravelIdea\Helper\App\Models\_IH_TimeSheet_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    
    /**
     * @property int $id
     * @property string $employee_id
     * @property string|null $house_phone
     * @property string $mobile_phone
     * @property string $email
     * @property string $address1
     * @property string|null $address2
     * @property string $city
     * @property bool $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Employee $employee
     * @method BelongsTo|_IH_Employee_QB employee()
     * @method static _IH_Address_QB onWriteConnection()
     * @method _IH_Address_QB newQuery()
     * @method static _IH_Address_QB on(null|string $connection = null)
     * @method static _IH_Address_QB query()
     * @method static _IH_Address_QB with(array|string $relations)
     * @method _IH_Address_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Address_C|Address[] all($columns = ['*'])
     * @ownLinks employee_id,\App\Models\Employee,employee_id
     * @mixin _IH_Address_QB
     */
    class Address extends Model {}
    
    /**
     * @property int $id
     * @property float $amount
     * @property string $category
     * @property string $description
     * @property string $name
     * @property string|null $phone
     * @property int $customer_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_CashOut_QB onWriteConnection()
     * @method _IH_CashOut_QB newQuery()
     * @method static _IH_CashOut_QB on(null|string $connection = null)
     * @method static _IH_CashOut_QB query()
     * @method static _IH_CashOut_QB with(array|string $relations)
     * @method _IH_CashOut_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CashOut_C|CashOut[] all($columns = ['*'])
     * @ownLinks customer_id,\App\Models\Customer,id
     * @mixin _IH_CashOut_QB
     */
    class CashOut extends Model {}
    
    /**
     * @property int $id
     * @property string $employee_id
     * @property string $first_name
     * @property string $last_name
     * @property string|null $middle_name
     * @property string $children_status
     * @property string $gender
     * @property int|null $age
     * @property Carbon $birthday
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Child_QB onWriteConnection()
     * @method _IH_Child_QB newQuery()
     * @method static _IH_Child_QB on(null|string $connection = null)
     * @method static _IH_Child_QB query()
     * @method static _IH_Child_QB with(array|string $relations)
     * @method _IH_Child_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Child_C|Child[] all($columns = ['*'])
     * @ownLinks employee_id,\App\Models\Employee,employee_id
     * @mixin _IH_Child_QB
     */
    class Child extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string|null $id_nat
     * @property string|null $rccm
     * @property string|null $nif
     * @property string|null $province
     * @property string|null $ville
     * @property string|null $commune
     * @property string|null $quartier
     * @property string|null $avenue
     * @property string|null $numero
     * @property string|null $telephone
     * @property string|null $email
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Invoice_C|Invoice[] $invoices
     * @property-read int $invoices_count
     * @method HasMany|_IH_Invoice_QB invoices()
     * @method static _IH_Customer_QB onWriteConnection()
     * @method _IH_Customer_QB newQuery()
     * @method static _IH_Customer_QB on(null|string $connection = null)
     * @method static _IH_Customer_QB query()
     * @method static _IH_Customer_QB with(array|string $relations)
     * @method _IH_Customer_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Customer_C|Customer[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\purchase_orders,customer_id|id,\App\Models\Invoice,customer_id|id,\App\Models\CashOut,customer_id
     * @mixin _IH_Customer_QB
     * @method static CustomerFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class Customer extends Model {}
    
    /**
     * @property int $id
     * @property string $employee_id
     * @property string|null $title
     * @property string|null $full_name
     * @property string|null $relationship
     * @property string|null $mobile_phone
     * @property string|null $address
     * @property string|null $city
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Emergency_QB onWriteConnection()
     * @method _IH_Emergency_QB newQuery()
     * @method static _IH_Emergency_QB on(null|string $connection = null)
     * @method static _IH_Emergency_QB query()
     * @method static _IH_Emergency_QB with(array|string $relations)
     * @method _IH_Emergency_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Emergency_C|Emergency[] all($columns = ['*'])
     * @ownLinks employee_id,\App\Models\Employee,employee_id
     * @mixin _IH_Emergency_QB
     */
    class Emergency extends Model {}
    
    /**
     * @property int $id
     * @property string $employee_id
     * @property string|null $first_name
     * @property string|null $last_name
     * @property string|null $middle_name
     * @property string|null $personal_id
     * @property Carbon|null $birth_date
     * @property string|null $gender
     * @property string|null $marital_status
     * @property string|null $highest_education_level
     * @property string|null $nationality
     * @property string|null $photo
     * @property int|null $age
     * @property string|null $house_phone
     * @property string|null $mobile_phone
     * @property string|null $email
     * @property string|null $address1
     * @property string|null $address2
     * @property string|null $city
     * @property int $status
     * @property string|null $emergency_full_name
     * @property string|null $emergency_relationship
     * @property string|null $emergency_mobile_phone
     * @property string|null $emergency_address
     * @property string|null $emergency_city
     * @property string|null $father_name
     * @property string|null $father_name_status
     * @property string|null $mother_name
     * @property string|null $mother_name_status
     * @property string|null $spouse_name
     * @property string|null $spouse_phone
     * @property Carbon|null $spouse_birth_date
     * @property string|null $department
     * @property string|null $function
     * @property string|null $niveau
     * @property string|null $echelon
     * @property string|null $contract_type
     * @property string|null $taux_horaire_brut
     * @property string|null $situation_avant_embauche
     * @property float|null $salaire_mensuel_brut
     * @property Carbon|null $end_contract_date
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Address $address
     * @method HasOne|_IH_Address_QB address()
     * @property _IH_Child_C|Child[] $child
     * @property-read int $child_count
     * @method HasMany|_IH_Child_QB child()
     * @property Emergency $emergency
     * @method HasOne|_IH_Emergency_QB emergency()
     * @property EndContract $endContract
     * @method HasOne|_IH_EndContract_QB endContract()
     * @property EmployeeEntreprise $entreprise
     * @method HasOne|_IH_EmployeeEntreprise_QB entreprise()
     * @property Familly $family
     * @method HasOne|_IH_Familly_QB family()
     * @property Payroll $payroll
     * @method HasOne|_IH_Payroll_QB payroll()
     * @property _IH_TimeSheet_C|TimeSheet[] $timeSheets
     * @property-read int $time_sheets_count
     * @method HasMany|_IH_TimeSheet_QB timeSheets()
     * @method static _IH_Employee_QB onWriteConnection()
     * @method _IH_Employee_QB newQuery()
     * @method static _IH_Employee_QB on(null|string $connection = null)
     * @method static _IH_Employee_QB query()
     * @method static _IH_Employee_QB with(array|string $relations)
     * @method _IH_Employee_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Employee_C|Employee[] all($columns = ['*'])
     * @foreignLinks employee_id,\App\Models\Emergency,employee_id|employee_id,\App\Models\Child,employee_id|employee_id,\App\Models\EmployeeEntreprise,employee_id|employee_id,\App\Models\Address,employee_id|employee_id,\App\Models\Familly,employee_id|employee_id,\App\Models\Payroll,employee_id|id,\App\Models\TimeSheet,employee_id|employee_id,\App\Models\EndContract,employee_id
     * @mixin _IH_Employee_QB
     * @method static EmployeeFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class Employee extends Model {}
    
    /**
     * @property int $id
     * @property string $employee_id
     * @property string $function
     * @property string $job_title
     * @property string $department
     * @property string $niveau
     * @property string $echelon
     * @property string $salaire_mesuel_brut
     * @property string $salaire_horaire
     * @property string $taux_horaire_brut_fc
     * @property string $type_contract
     * @property string $situation_avant_debauche
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_EmployeeEntreprise_QB onWriteConnection()
     * @method _IH_EmployeeEntreprise_QB newQuery()
     * @method static _IH_EmployeeEntreprise_QB on(null|string $connection = null)
     * @method static _IH_EmployeeEntreprise_QB query()
     * @method static _IH_EmployeeEntreprise_QB with(array|string $relations)
     * @method _IH_EmployeeEntreprise_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EmployeeEntreprise_C|EmployeeEntreprise[] all($columns = ['*'])
     * @ownLinks employee_id,\App\Models\Employee,employee_id
     * @mixin _IH_EmployeeEntreprise_QB
     */
    class EmployeeEntreprise extends Model {}
    
    /**
     * @property int $id
     * @property string $employee_id
     * @property Carbon $end_date
     * @property string $reason
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Employee $employee
     * @method BelongsTo|_IH_Employee_QB employee()
     * @method static _IH_EndContract_QB onWriteConnection()
     * @method _IH_EndContract_QB newQuery()
     * @method static _IH_EndContract_QB on(null|string $connection = null)
     * @method static _IH_EndContract_QB query()
     * @method static _IH_EndContract_QB with(array|string $relations)
     * @method _IH_EndContract_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_EndContract_C|EndContract[] all($columns = ['*'])
     * @ownLinks employee_id,\App\Models\Employee,employee_id
     * @mixin _IH_EndContract_QB
     */
    class EndContract extends Model {}
    
    /**
     * @property int $id
     * @property string $employee_id
     * @property string|null $father_name
     * @property string|null $father_name_status
     * @property string|null $mother_name
     * @property string|null $mother_name_status
     * @property string|null $married
     * @property string|null $married_status
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Employee $employee
     * @method BelongsTo|_IH_Employee_QB employee()
     * @method static _IH_Familly_QB onWriteConnection()
     * @method _IH_Familly_QB newQuery()
     * @method static _IH_Familly_QB on(null|string $connection = null)
     * @method static _IH_Familly_QB query()
     * @method static _IH_Familly_QB with(array|string $relations)
     * @method _IH_Familly_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Familly_C|Familly[] all($columns = ['*'])
     * @ownLinks employee_id,\App\Models\Employee,employee_id
     * @mixin _IH_Familly_QB
     */
    class Familly extends Model {}
    
    /**
     * @property int $id
     * @property int $customer_id
     * @property string|null $po
     * @property string|null $numero_invoice
     * @property string $description
     * @property string|null $unite
     * @property int $quantity
     * @property int $nb_jours
     * @property float $pu
     * @property float $pt_jours
     * @property float $pt_mois
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Customer $customer
     * @method BelongsTo|_IH_Customer_QB customer()
     * @method static _IH_Invoice_QB onWriteConnection()
     * @method _IH_Invoice_QB newQuery()
     * @method static _IH_Invoice_QB on(null|string $connection = null)
     * @method static _IH_Invoice_QB query()
     * @method static _IH_Invoice_QB with(array|string $relations)
     * @method _IH_Invoice_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Invoice_C|Invoice[] all($columns = ['*'])
     * @ownLinks customer_id,\App\Models\Customer,id
     * @mixin _IH_Invoice_QB
     */
    class Invoice extends Model {}
    
    /**
     * @property int $id
     * @property string $employee_id
     * @property float|null $basic_usd_salary
     * @property Carbon|null $start_contract_date
     * @property int|null $tax_dependants
     * @property int|null $worked_days
     * @property float|null $baremic_salary
     * @property float|null $accommodation_allowance
     * @property float|null $sick_leave
     * @property float|null $overtime_30
     * @property float|null $overtime_60
     * @property float|null $overtime_100
     * @property float|null $total_earnings
     * @property float|null $inss_5
     * @property float|null $monthly_ipr
     * @property float|null $ipr_rate
     * @property float|null $net
     * @property float|null $net_usd
     * @property float|null $cnss_13
     * @property float|null $inpp_2
     * @property float|null $onem_0_2
     * @property float|null $total_taxes_cdf
     * @property float|null $royalties_10_usd
     * @property float|null $inss_tax_base
     * @property float|null $ipr_tax_base
     * @property float|null $annual_ipr_tax_base
     * @property float|null $tranche_2
     * @property float|null $tranche_3
     * @property float|null $tranche_more_3
     * @property float|null $deduction
     * @property Carbon|null $period
     * @property float|null $exchange_rate
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Employee $employee
     * @method BelongsTo|_IH_Employee_QB employee()
     * @method static _IH_Payroll_QB onWriteConnection()
     * @method _IH_Payroll_QB newQuery()
     * @method static _IH_Payroll_QB on(null|string $connection = null)
     * @method static _IH_Payroll_QB query()
     * @method static _IH_Payroll_QB with(array|string $relations)
     * @method _IH_Payroll_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Payroll_C|Payroll[] all($columns = ['*'])
     * @ownLinks employee_id,\App\Models\Employee,employee_id
     * @mixin _IH_Payroll_QB
     */
    class Payroll extends Model {}
    
    /**
     * @property int $id
     * @property int $employee_id
     * @property Carbon|null $date
     * @property Carbon|null $start_time
     * @property Carbon|null $end_time
     * @property float|null $hours_worked
     * @property string|null $work_location
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Employee $employee
     * @method BelongsTo|_IH_Employee_QB employee()
     * @method static _IH_TimeSheet_QB onWriteConnection()
     * @method _IH_TimeSheet_QB newQuery()
     * @method static _IH_TimeSheet_QB on(null|string $connection = null)
     * @method static _IH_TimeSheet_QB query()
     * @method static _IH_TimeSheet_QB with(array|string $relations)
     * @method _IH_TimeSheet_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_TimeSheet_C|TimeSheet[] all($columns = ['*'])
     * @ownLinks employee_id,\App\Models\Employee,id
     * @mixin _IH_TimeSheet_QB
     */
    class TimeSheet extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property mixed $password
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all($columns = ['*'])
     * @foreignLinks 
     * @mixin _IH_User_QB
     * @method static UserFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class User extends Model {}
    
    /**
     * @property int $id
     * @property string|null $company
     * @property string|null $address
     * @property string|null $country
     * @property string|null $id_nat
     * @property string|null $rccm
     * @property string|null $nif
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_clients_QB onWriteConnection()
     * @method _IH_clients_QB newQuery()
     * @method static _IH_clients_QB on(null|string $connection = null)
     * @method static _IH_clients_QB query()
     * @method static _IH_clients_QB with(array|string $relations)
     * @method _IH_clients_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_clients_C|clients[] all($columns = ['*'])
     * @mixin _IH_clients_QB
     */
    class clients extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_fonction_C|fonction[] $functions
     * @property-read int $functions_count
     * @method HasMany|_IH_fonction_QB functions()
     * @property _IH_salary_grid_C|salary_grid[] $salaryGrids
     * @property-read int $salary_grids_count
     * @method HasMany|_IH_salary_grid_QB salaryGrids()
     * @method static _IH_department_QB onWriteConnection()
     * @method _IH_department_QB newQuery()
     * @method static _IH_department_QB on(null|string $connection = null)
     * @method static _IH_department_QB query()
     * @method static _IH_department_QB with(array|string $relations)
     * @method _IH_department_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_department_C|department[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\fonction,department_id|id,\App\Models\salary_grid,department_id
     * @mixin _IH_department_QB
     */
    class department extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property int $niveau_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property niveau $niveau
     * @method BelongsTo|_IH_niveau_QB niveau()
     * @property _IH_salary_grid_C|salary_grid[] $salaryGrids
     * @property-read int $salary_grids_count
     * @method HasMany|_IH_salary_grid_QB salaryGrids()
     * @method static _IH_echelon_QB onWriteConnection()
     * @method _IH_echelon_QB newQuery()
     * @method static _IH_echelon_QB on(null|string $connection = null)
     * @method static _IH_echelon_QB query()
     * @method static _IH_echelon_QB with(array|string $relations)
     * @method _IH_echelon_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_echelon_C|echelon[] all($columns = ['*'])
     * @ownLinks niveau_id,\App\Models\niveau,id
     * @foreignLinks id,\App\Models\salary_grid,echelon_id
     * @mixin _IH_echelon_QB
     */
    class echelon extends Model {}
    
    /**
     * @property int $id
     * @property string $employee_id
     * @property Carbon $end_date
     * @property string $reason
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Employee $employee
     * @method BelongsTo|_IH_Employee_QB employee()
     * @method static _IH_end_contracts_QB onWriteConnection()
     * @method _IH_end_contracts_QB newQuery()
     * @method static _IH_end_contracts_QB on(null|string $connection = null)
     * @method static _IH_end_contracts_QB query()
     * @method static _IH_end_contracts_QB with(array|string $relations)
     * @method _IH_end_contracts_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_end_contracts_C|end_contracts[] all($columns = ['*'])
     * @ownLinks employee_id,\App\Models\Employee,employee_id
     * @mixin _IH_end_contracts_QB
     */
    class end_contracts extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property int $department_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property department $department
     * @method BelongsTo|_IH_department_QB department()
     * @property _IH_salary_grid_C|salary_grid[] $salaryGrids
     * @property-read int $salary_grids_count
     * @method HasMany|_IH_salary_grid_QB salaryGrids()
     * @method static _IH_fonction_QB onWriteConnection()
     * @method _IH_fonction_QB newQuery()
     * @method static _IH_fonction_QB on(null|string $connection = null)
     * @method static _IH_fonction_QB query()
     * @method static _IH_fonction_QB with(array|string $relations)
     * @method _IH_fonction_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_fonction_C|fonction[] all($columns = ['*'])
     * @ownLinks department_id,\App\Models\department,id
     * @foreignLinks id,\App\Models\salary_grid,fonction_id
     * @mixin _IH_fonction_QB
     */
    class fonction extends Model {}
    
    /**
     * @property int $id
     * @property string $po_order
     * @property Carbon $date
     * @property string|null $description
     * @property string $invoice_number
     * @property float $amount
     * @property float $payment
     * @property float $balance
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_items_QB onWriteConnection()
     * @method _IH_items_QB newQuery()
     * @method static _IH_items_QB on(null|string $connection = null)
     * @method static _IH_items_QB query()
     * @method static _IH_items_QB with(array|string $relations)
     * @method _IH_items_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_items_C|items[] all($columns = ['*'])
     * @mixin _IH_items_QB
     */
    class items extends Model {}
    
    /**
     * @method static _IH_kitservice_QB onWriteConnection()
     * @method _IH_kitservice_QB newQuery()
     * @method static _IH_kitservice_QB on(null|string $connection = null)
     * @method static _IH_kitservice_QB query()
     * @method static _IH_kitservice_QB with(array|string $relations)
     * @method _IH_kitservice_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_kitservice_C|kitservice[] all($columns = ['*'])
     * @mixin _IH_kitservice_QB
     * @method static kitserviceFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class kitservice extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_echelon_C|echelon[] $echelons
     * @property-read int $echelons_count
     * @method HasMany|_IH_echelon_QB echelons()
     * @property _IH_salary_grid_C|salary_grid[] $salaryGrids
     * @property-read int $salary_grids_count
     * @method HasMany|_IH_salary_grid_QB salaryGrids()
     * @method static _IH_niveau_QB onWriteConnection()
     * @method _IH_niveau_QB newQuery()
     * @method static _IH_niveau_QB on(null|string $connection = null)
     * @method static _IH_niveau_QB query()
     * @method static _IH_niveau_QB with(array|string $relations)
     * @method _IH_niveau_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_niveau_C|niveau[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\echelon,niveau_id|id,\App\Models\salary_grid,niveau_id
     * @mixin _IH_niveau_QB
     */
    class niveau extends Model {}
    
    /**
     * @property int $id
     * @property int $customer_id
     * @property string $po_number
     * @property Carbon $date
     * @property string $description
     * @property string|null $location
     * @property string|null $additional_notes
     * @property string|null $invoice_number
     * @property float $amount
     * @property float $amount_paid
     * @property float $balance
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_purchase_orders_QB onWriteConnection()
     * @method _IH_purchase_orders_QB newQuery()
     * @method static _IH_purchase_orders_QB on(null|string $connection = null)
     * @method static _IH_purchase_orders_QB query()
     * @method static _IH_purchase_orders_QB with(array|string $relations)
     * @method _IH_purchase_orders_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_purchase_orders_C|purchase_orders[] all($columns = ['*'])
     * @ownLinks customer_id,\App\Models\Customer,id
     * @mixin _IH_purchase_orders_QB
     */
    class purchase_orders extends Model {}
    
    /**
     * @property int $id
     * @property int $department_id
     * @property int $fonction_id
     * @property int $niveau_id
     * @property int $echelon_id
     * @property float|null $base_salary
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property department $department
     * @method BelongsTo|_IH_department_QB department()
     * @property echelon $echelon
     * @method BelongsTo|_IH_echelon_QB echelon()
     * @property fonction $fonction
     * @method BelongsTo|_IH_fonction_QB fonction()
     * @property niveau $niveau
     * @method BelongsTo|_IH_niveau_QB niveau()
     * @method static _IH_salary_grid_QB onWriteConnection()
     * @method _IH_salary_grid_QB newQuery()
     * @method static _IH_salary_grid_QB on(null|string $connection = null)
     * @method static _IH_salary_grid_QB query()
     * @method static _IH_salary_grid_QB with(array|string $relations)
     * @method _IH_salary_grid_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_salary_grid_C|salary_grid[] all($columns = ['*'])
     * @ownLinks department_id,\App\Models\department,id|fonction_id,\App\Models\fonction,id|niveau_id,\App\Models\niveau,id|echelon_id,\App\Models\echelon,id
     * @mixin _IH_salary_grid_QB
     */
    class salary_grid extends Model {}
}