<?php $__env->startSection('title', 'Kit Service | Edit Employee'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container px-4 md:px-6 mx-auto grid">

        <!-- Tabs -->
        <div class="mb-6">
            <div class="flex border-b dark:border-gray-700 space-x-4">
                <button type="button" class="tab-btn active-tab" data-target="employee-section">Employee</button>
                <button type="button" class="tab-btn" data-target="address-section">Address</button>
                <button type="button" class="tab-btn" data-target="emergency-section">Emergency</button>
                <button type="button" class="tab-btn" data-target="family-section">Family</button>
                <button type="button" class="tab-btn" data-target="entreprise-section">Entreprise</button>
                <button type="button" class="tab-btn" data-target="picture-section">Picture</button>
            </div>
        </div>

        <form id="employeeForm" action="<?php echo e(route('employees.update', $employee->employee_id)); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>


            
            <div id="employee-section" class="tab-content active p-6 mb-8 bg-white rounded-lg shadow-md dark:bg-gray-800">
                <h3 class="text-lg font-semibold text-gray-700 dark:text-gray-300 mb-4">
                    Edit Employee Information for <?php echo e($employee->first_name .' '. $employee->last_name); ?>

                </h3>

                <div class="flex flex-col md:flex-row gap-6">
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">First Name</label>
                        <input type="text" name="first_name" id="first_name"
                               value="<?php echo e(old('first_name', $employee->first_name)); ?>"
                               class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring focus:ring-orange-400" />
                    </div>

                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Last Name</label>
                        <input type="text" name="last_name" id="last_name"
                               value="<?php echo e(old('last_name', $employee->last_name)); ?>"
                               class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring focus:ring-orange-400" />
                    </div>

                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Middle Name</label>
                        <input type="text" name="middle_name" id="middle_name"
                               value="<?php echo e(old('middle_name', $employee->middle_name)); ?>"
                               class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring focus:ring-orange-400" />
                    </div>
                </div>

                <div class="flex flex-col md:flex-row gap-6 mt-4">
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Personal ID</label>
                        <input type="text" name="personal_id" id="personal_id"
                               value="<?php echo e(old('personal_id', $employee->personal_id)); ?>"
                               class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring focus:ring-orange-400" />
                    </div>

                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Birth Date</label>
                        <input type="date" name="birth_date" id="birth_date"
                               value="<?php echo e(old('birth_date', optional($employee->birth_date)->format('Y-m-d') ?? $employee->birth_date)); ?>"
                               class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring focus:ring-orange-400" />
                    </div>

                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Nationality</label>
                        <input type="text" name="nationality" id="nationality"
                               value="<?php echo e(old('nationality', $employee->nationality)); ?>"
                               class="w-full px-3 py-2 border rounded-md focus:outline-none focus:ring focus:ring-orange-400" />
                    </div>
                </div>

                <div class="flex flex-col md:flex-row gap-6 mt-4 items-end">
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Gender</label>
                        <div class="flex items-center space-x-4">
                            <label class="inline-flex items-center">
                                <input type="radio" name="gender" value="M"
                                       <?php echo e(old('gender', $employee->gender) == 'M' ? 'checked' : ''); ?>

                                       class="form-radio" />
                                <span class="ml-2">M</span>
                            </label>
                            <label class="inline-flex items-center">
                                <input type="radio" name="gender" value="F"
                                       <?php echo e(old('gender', $employee->gender) == 'F' ? 'checked' : ''); ?>

                                       class="form-radio" />
                                <span class="ml-2">F</span>
                            </label>
                        </div>
                    </div>

                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Marital Status</label>
                        <select name="marital_status" id="marital_status" class="w-full px-3 py-2 border rounded-md">
                            <?php $__currentLoopData = ['Single','Married','Divorced','Widowed']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ms): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($ms); ?>" <?php echo e(old('marital_status', $employee->marital_status) == $ms ? 'selected' : ''); ?>>
                                    <?php echo e($ms); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Education Level</label>
                        <select name="highest_education_level" id="highest_education_level" class="w-full px-3 py-2 border rounded-md">
                            <?php $__currentLoopData = ['High School','Bachelor','Master','PhD']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ed): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($ed); ?>" <?php echo e(old('highest_education_level', $employee->highest_education_level) == $ed ? 'selected' : ''); ?>>
                                    <?php echo e($ed); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>

            
            <div id="address-section" class="tab-content p-6 mb-8 bg-white rounded-lg shadow-md dark:bg-gray-800">
                <h3 class="text-lg font-semibold text-gray-700 dark:text-gray-300 mb-4">Address Information</h3>

                <div class="flex flex-col md:flex-row gap-6">
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">House Phone</label>
                        <input type="text" name="house_phone" id="house_phone"
                               value="<?php echo e(old('house_phone', $employee->house_phone)); ?>"
                               class="w-full px-3 py-2 border rounded-md" />
                    </div>
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Mobile Phone</label>
                        <input type="text" name="mobile_phone" id="mobile_phone"
                               value="<?php echo e(old('mobile_phone', $employee->mobile_phone)); ?>"
                               class="w-full px-3 py-2 border rounded-md" />
                    </div>
                </div>

                <div class="flex flex-col md:flex-row gap-6 mt-4">
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Email</label>
                        <input type="email" name="email" id="email"
                               value="<?php echo e(old('email', $employee->email)); ?>"
                               class="w-full px-3 py-2 border rounded-md" />
                    </div>
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Address Line 1</label>
                        <input type="text" name="address1" id="address1"
                               value="<?php echo e(old('address1', $employee->address1)); ?>"
                               class="w-full px-3 py-2 border rounded-md" />
                    </div>
                </div>

                <div class="flex flex-col md:flex-row gap-6 mt-4">
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Address Line 2</label>
                        <input type="text" name="address2" id="address2"
                               value="<?php echo e(old('address2', $employee->address2)); ?>"
                               class="w-full px-3 py-2 border rounded-md" />
                    </div>
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">City</label>
                        <input type="text" name="city" id="city"
                               value="<?php echo e(old('city', $employee->city)); ?>"
                               class="w-full px-3 py-2 border rounded-md" />
                    </div>
                </div>
            </div>

            
            <div id="emergency-section" class="tab-content p-6 mb-8 bg-white rounded-lg shadow-md dark:bg-gray-800">
                <h3 class="text-lg font-semibold text-gray-700 dark:text-gray-300 mb-4">Emergency Contact</h3>

                <div class="flex flex-col md:flex-row gap-6">
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Relationship</label>
                        <select name="emergency_relationship" id="emergency_relationship" class="w-full px-3 py-2 border rounded-md">
                            <?php $__currentLoopData = ['Mr','Mss','Dr','Father','Mother','Uncle','Tante','Husband','Wife']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($r); ?>" <?php echo e(old('emergency_relationship', $employee->emergency_relationship) == $r ? 'selected' : ''); ?>>
                                    <?php echo e($r); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Full Name</label>
                        <input type="text" name="emergency_full_name" id="emergency_full_name"
                               value="<?php echo e(old('emergency_full_name', $employee->emergency_full_name)); ?>"
                               class="w-full px-3 py-2 border rounded-md" />
                    </div>
                </div>

                <div class="flex flex-col md:flex-row gap-6 mt-4">
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Mobile Phone</label>
                        <input type="text" name="emergency_mobile_phone" id="emergency_mobile_phone"
                               value="<?php echo e(old('emergency_mobile_phone', $employee->emergency_mobile_phone)); ?>"
                               class="w-full px-3 py-2 border rounded-md" />
                    </div>
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">City</label>
                        <input type="text" name="emergency_city" id="emergency_city"
                               value="<?php echo e(old('emergency_city', $employee->emergency_city)); ?>"
                               class="w-full px-3 py-2 border rounded-md" />
                    </div>
                </div>

                <div class="mt-4">
                    <label class="block text-gray-700 mb-1">Address</label>
                    <input type="text" name="emergency_address" id="emergency_address"
                           value="<?php echo e(old('emergency_address', $employee->emergency_address)); ?>"
                           class="w-full px-3 py-2 border rounded-md" />
                </div>
            </div>

            
            <div id="family-section" class="tab-content p-6 mb-8 bg-white rounded-lg shadow-md dark:bg-gray-800">
                <h3 class="text-lg font-semibold text-gray-700 dark:text-gray-300 mb-4">Family Information</h3>

                <div class="flex flex-col md:flex-row gap-6">
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Father's Name</label>
                        <input type="text" name="father_name" id="father_name"
                               value="<?php echo e(old('father_name', $employee->father_name)); ?>"
                               class="w-full px-3 py-2 border rounded-md" />
                    </div>

                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Father's Status</label>
                        <select name="father_name_status" id="father_name_status" class="w-full px-3 py-2 border rounded-md">
                            <?php $__currentLoopData = ['Alive'=>'Alive','Deceased'=>'Deceased']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($k); ?>" <?php echo e(old('father_name_status', $employee->father_name_status) == $k ? 'selected' : ''); ?>>
                                    <?php echo e($v); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div class="flex flex-col md:flex-row gap-6 mt-4">
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Mother's Name</label>
                        <input type="text" name="mother_name" id="mother_name"
                               value="<?php echo e(old('mother_name', $employee->mother_name)); ?>"
                               class="w-full px-3 py-2 border rounded-md" />
                    </div>

                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Mother's Status</label>
                        <select name="mother_name_status" id="mother_name_status" class="w-full px-3 py-2 border rounded-md">
                            <?php $__currentLoopData = ['Alive'=>'Alive','Deceased'=>'Deceased']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($k); ?>" <?php echo e(old('mother_name_status', $employee->mother_name_status) == $k ? 'selected' : ''); ?>>
                                    <?php echo e($v); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div class="flex flex-col md:flex-row gap-6 mt-4">
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Spouse Name</label>
                        <input type="text" name="spouse_name" id="spouse_name"
                               value="<?php echo e(old('spouse_name', $employee->spouse_name)); ?>"
                               class="w-full px-3 py-2 border rounded-md" />
                    </div>

                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Spouse Phone</label>
                        <input type="text" name="spouse_phone" id="spouse_phone"
                               value="<?php echo e(old('spouse_phone', $employee->spouse_phone)); ?>"
                               class="w-full px-3 py-2 border rounded-md" />
                    </div>

                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Spouse Birth Date</label>
                        <input type="date" name="spouse_birth_date" id="spouse_birth_date"
                               value="<?php echo e(old('spouse_birth_date', optional($employee->spouse_birth_date)->format('Y-m-d') ?? $employee->spouse_birth_date)); ?>"
                               class="w-full px-3 py-2 border rounded-md" />
                    </div>
                </div>
            </div>

            
            <div id="entreprise-section" class="tab-content p-6 mb-8 bg-white rounded-lg shadow-md dark:bg-gray-800">
                <h3 class="text-lg font-semibold text-gray-700 dark:text-gray-300 mb-4">Entreprise Information</h3>

                <div class="flex flex-col md:flex-row gap-6">
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Department</label>
                        <select name="department" id="department" class="w-full px-3 py-2 border rounded-md">
                            <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($dept); ?>" <?php echo e(old('department', $employee->department) == $dept ? 'selected' : ''); ?>>
                                    <?php echo e($dept); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Function</label>
                        <select name="function" id="function" class="w-full px-3 py-2 border rounded-md">
                            <?php $__currentLoopData = $fonctions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fun): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($fun); ?>" <?php echo e(old('function', $employee->function) == $fun ? 'selected' : ''); ?>>
                                    <?php echo e($fun); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div class="flex flex-col md:flex-row gap-6 mt-4">
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Niveau</label>
                        <select name="niveau" id="niveau" class="w-full px-3 py-2 border rounded-md">
                            <?php $__currentLoopData = $niveaux; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $niv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($niv); ?>" <?php echo e(old('niveau', $employee->niveau) == $niv ? 'selected' : ''); ?>>
                                    <?php echo e($niv); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Echelon</label>
                        <select name="echelon" id="echelon" class="w-full px-3 py-2 border rounded-md">
                            <?php $__currentLoopData = $echelons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ech): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($ech); ?>" <?php echo e(old('echelon', $employee->echelon) == $ech ? 'selected' : ''); ?>>
                                    <?php echo e($ech); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div class="flex flex-col md:flex-row gap-6 mt-4">
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Situation avant embauche</label>
                        <select name="situation_avant_embauche" id="situation_avant_embauche" class="w-full px-3 py-2 border rounded-md">
                            <?php $__currentLoopData = ['Stagiaire'=>'Stagiaire','Chômeur'=>'Chômeur','Étudiant'=>'Étudiant','Étudiante'=>'Étudiante','Travailleur'=>'Travailleur']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($k); ?>" <?php echo e(old('situation_avant_embauche', $employee->situation_avant_embauche) == $k ? 'selected' : ''); ?>>
                                    <?php echo e($v); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Taux horaire brut (FC)</label>
                        <input type="number" name="taux_horaire_brut" id="taux_horaire_brut"
                               value="<?php echo e(old('taux_horaire_brut', $employee->taux_horaire_brut)); ?>"
                               class="w-full px-3 py-2 border rounded-md bg-gray-50" />
                    </div>
                </div>

                <div class="flex flex-col md:flex-row gap-6 mt-4">
                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Contract Type</label>
                        <select name="contract_type" id="contract_type" class="w-full px-3 py-2 border rounded-md">
                            <?php $__currentLoopData = ['CDI'=>'CDI','CDD'=>'CDD','Stage'=>'Stage']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($k); ?>" <?php echo e(old('contract_type', $employee->contract_type) == $k ? 'selected' : ''); ?>><?php echo e($v); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="flex-1">
                        <label class="block text-gray-700 mb-1">Salaire mensuel brut</label>
                        <input type="number" name="salaire_mensuel_brut" id="salaire_mensuel_brut"
                               value="<?php echo e(old('salaire_mensuel_brut', $employee->salaire_mensuel_brut)); ?>"
                               class="w-full px-3 py-2 border rounded-md bg-gray-50" />
                    </div>
                </div>
            </div>


            <div id="picture-section" class="tab-content p-6 mb-8 bg-white rounded-lg shadow-md dark:bg-gray-800">
                <h3 class="text-lg font-semibold text-gray-700 dark:text-gray-300 mb-4">Upload Picture</h3>
                <div class="mb-4">
                    <label class="block text-gray-700 mb-2">Upload Picture</label>
                    <div class="upload-btn-wrapper bg-orange-500 text-white px-4 py-2 rounded inline-block cursor-pointer">
                        <span>Choose File</span>
                        <input type="file" id="upload" name="photo" accept="image/*" />
                    </div>
                    <span id="file-name" class="ml-2 text-gray-600"><?php echo e($employee->photo); ?></span>

                    <?php if($employee->photo): ?>
                        <div class="mt-3">
                            <img src="<?php echo e(asset('storage/' . $employee->photo)); ?>" alt="photo" class="w-28 h-28 object-cover rounded">
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            
            <div class="flex justify-end mb-10 space-x-3">

                <a href="<?php echo e(route('employees.index')); ?>"
                   class="bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600 transition text-sm">
                    Cancel
                </a>

                <button type="submit"
                        class="bg-orange-500 text-white px-4 py-2 rounded hover:bg-orange-600 transition text-sm">
                    Save
                </button>
            </div>


        </form>
    </div>

    
    <style>
        .tab-content { display: none; }
        .tab-content.active { display: block; }
        .tab-btn.active-tab { border-bottom: 2px solid #f97316; color: #f97316; font-weight: bold; }
        .tab-btn { padding: 0.5rem 1rem; cursor: pointer; transition: 0.2s; border-bottom: 2px solid transparent; }
        .orange-btn { background-color: #f97316; color: white; font-weight: bold; padding: 0.5rem 1rem; border-radius: 0.5rem; }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const tabButtons = document.querySelectorAll('.tab-btn');
            const tabContents = document.querySelectorAll('.tab-content');

            // Montrer la première tab au départ
            tabContents.forEach(tc => tc.classList.remove('active'));
            if(tabContents.length>0) tabContents[0].classList.add('active');

            tabButtons.forEach(btn => {
                btn.addEventListener('click', () => {
                    tabContents.forEach(tc => tc.classList.remove('active'));
                    tabButtons.forEach(b => b.classList.remove('active-tab'));

                    document.getElementById(btn.dataset.target).classList.add('active');
                    btn.classList.add('active-tab');
                });
            });

            // preview filename
            const upload = document.getElementById('upload');
            const fileName = document.getElementById('file-name');
            if(upload){
                upload.addEventListener('change', (e) => {
                    const f = e.target.files[0];
                    if(f) fileName.textContent = f.name;
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/jeanluckawel/PhpstormProjects/KitServices/resources/views/employees/edit.blade.php ENDPATH**/ ?>