<?php $__env->startSection('content'); ?>

    <style>
        .orange-btn {
            background-color: #f97316; /* orange-500 */
            color: white;
            font-weight: bold;
            padding: 0.5rem 1rem;
            border: none;
            border-radius: 0.25rem;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .orange-btn:hover {
            background-color: #ea580c; /* orange-600 */
        }

    </style>
    <div class="max-w-xl mx-auto mt-10">
        <h2 class="text-2xl font-semibold mb-6">Importer des employés</h2>

        <?php if(session('success')): ?>
            <div class="bg-green-100 text-green-800 p-3 rounded mb-4">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if($errors->has('duplicates')): ?>
            <div class="bg-red-200 text-red-800 p-4 rounded mb-4">
                <?php echo e($errors->first('duplicates')); ?>

            </div>
        <?php endif; ?>


        <form action="<?php echo e(route('employees.import')); ?>" method="POST" enctype="multipart/form-data"
              class="bg-white p-6 rounded shadow-md border border-gray-200">
            <?php echo csrf_field(); ?>

            <label for="file" class="block mb-2 text-sm font-medium text-gray-700">Fichier Excel :</label>

            <div class="w-full border-2 border-dashed border-gray-300 p-4 rounded-lg bg-gray-50 hover:border-orange-400 transition">
                <input type="file" name="file" id="file" required
                       class="w-full text-sm text-gray-700 file:bg-orange-500 file:text-white file:px-4 file:py-2 file:rounded file:cursor-pointer" />
            </div>

            <?php $__errorArgs = ['file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <p class="text-red-500 text-sm mt-2"><?php echo e($message); ?></p>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            <br>

            <button type="submit" class="orange-btn">Cliquer ici</button>

        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/jeanluckawel/PhpstormProjects/KitServices/resources/views/employees/import.blade.php ENDPATH**/ ?>