<?php $__env->startSection('content'); ?>
    <div class="max-w-5xl mx-auto mt-10 p-6 bg-white rounded-2xl shadow border border-orange-200">

        <!-- Navigation -->
        <div class="flex space-x-4 mb-6">
            <a href="<?php echo e(route('dashboard')); ?>"
               class="px-4 py-2 text-sm font-medium text-gray-500 hover:text-orange-600 hover:border-orange-600 border-b-2 border-transparent">
                Dashboard
            </a>
            <span class="px-4 py-2 text-sm font-medium text-orange-600 border-b-2 border-orange-600">
            Enfants de <?php echo e($employee->first_name); ?> <?php echo e($employee->last_name); ?>

        </span>
        </div>

        <h2 class="text-2xl font-bold mb-6 text-orange-600">Manage Children</h2>

        <!-- Tabs -->
        <div x-data="{ tab: 'add' }">
            <nav class="flex border-b border-orange-200 mb-4">
                <button @click="tab = 'add'"
                        :class="tab === 'add' ? 'border-orange-600 text-orange-600' : 'text-gray-700'"
                        class="px-4 py-2 font-medium border-b-2">
                    Add Child
                </button>
                <button @click="tab = 'show'"
                        :class="tab === 'show' ? 'border-orange-600 text-orange-600' : 'text-gray-700'"
                        class="px-4 py-2 font-medium border-b-2">
                    Show Children
                </button>
            </nav>

            <!-- Add Child Form -->
            <div x-show="tab === 'add'" x-transition>
                <?php if(session('success')): ?>
                    <div class="mb-4 bg-green-100 text-green-800 p-3 rounded font-semibold">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                    <div class="mb-4 bg-red-100 text-red-800 p-3 rounded font-semibold">
                        <?php echo e($errors->first()); ?>

                    </div>
                <?php endif; ?>

                <form action="<?php echo e(route('children.store', $employee->employee_id)); ?>" method="POST" class="space-y-4">
                    <?php echo csrf_field(); ?>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block mb-1 text-sm font-semibold text-gray-700">Prénom <sup class="text-red-600">*</sup></label>
                            <input type="text" name="first_name" required value="<?php echo e(old('first_name')); ?>"
                                   class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-orange-500 focus:outline-none">
                        </div>
                        <div>
                            <label class="block mb-1 text-sm font-semibold text-gray-700">Nom <sup class="text-red-600">*</sup></label>
                            <input type="text" name="last_name" required value="<?php echo e(old('last_name')); ?>"
                                   class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-orange-500 focus:outline-none">
                        </div>
                        <div>
                            <label class="block mb-1 text-sm font-semibold text-gray-700">Deuxième prénom</label>
                            <input type="text" name="middle_name" value="<?php echo e(old('middle_name')); ?>"
                                   class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-orange-500 focus:outline-none">
                        </div>
                        <div>
                            <label class="block mb-1 text-sm font-semibold text-gray-700">Sexe <sup class="text-red-600">*</sup></label>
                            <div class="flex space-x-6 mt-2">
                                <label class="inline-flex items-center">
                                    <input type="radio" name="gender" value="M" required class="text-orange-600 focus:ring-orange-500">
                                    <span class="ml-2">Masculin</span>
                                </label>
                                <label class="inline-flex items-center">
                                    <input type="radio" name="gender" value="F" required class="text-orange-600 focus:ring-orange-500">
                                    <span class="ml-2">Féminin</span>
                                </label>
                            </div>
                        </div>
                        <div>
                            <label class="block mb-1 text-sm font-semibold text-gray-700">Date de naissance</label>
                            <input type="date" name="birthday" value="<?php echo e(old('birthday')); ?>"
                                   class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-orange-500 focus:outline-none">
                        </div>
                        <div>
                            <label class="block mb-1 text-sm font-semibold text-gray-700">Statut <sup class="text-red-600">*</sup></label>
                            <select name="children_status" required
                                    class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-orange-500 focus:outline-none">
                                <option value="">-- Choisir --</option>
                                <option value="en vie" <?php echo e(old('children_status') == 'en vie' ? 'selected' : ''); ?>>En vie</option>

                            </select>
                        </div>
                    </div>

                    <div class="flex space-x-4">
                        <!-- Bouton Save -->
                        <button type="submit" class="bg-orange-600 hover:bg-orange-700 text-white px-6 py-2 rounded-lg shadow">
                            Save
                        </button>

                        <!-- Bouton Back -->
                        <a href="<?php echo e(url()->previous()); ?>"
                           class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-2 rounded-lg shadow flex items-center justify-center">
                            Back
                        </a>
                    </div>

                </form>
            </div>

            <!-- Show Children Table -->
            <div x-show="tab === 'show'" x-transition class="overflow-auto max-h-96 border border-orange-300 rounded">
                <?php if($employee->child->isEmpty()): ?>
                    <p class="text-sm text-gray-500 p-4">Aucun enfant enregistré.</p>
                <?php else: ?>
                    <table class="min-w-full border-collapse text-sm">
                        <thead class="bg-orange-100 sticky top-0 z-10">
                        <tr>
                            <th class="border px-4 py-2 text-left text-orange-600">#</th>
                            <th class="border px-4 py-2 text-left text-orange-600">Prénom</th>
                            <th class="border px-4 py-2 text-left text-orange-600">Nom</th>
                            <th class="border px-4 py-2 text-left text-orange-600">Date de naissance</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $employee->child; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover:bg-orange-50">
                                <td class="border px-4 py-2"><?php echo e($child->id); ?></td>
                                <td class="border px-4 py-2"><?php echo e($child->first_name); ?></td>
                                <td class="border px-4 py-2"><?php echo e($child->last_name); ?></td>
                                <td class="border px-4 py-2">
                                    <?php echo e($child->birthday ? \Carbon\Carbon::parse($child->birthday)->format('d/m/Y') : '—'); ?>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/jeanluckawel/PhpstormProjects/KitServices/resources/views/children/create.blade.php ENDPATH**/ ?>