<?php $__env->startSection('title', 'Factures de ' . $customer->name); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-5xl mx-auto bg-white shadow p-6 rounded">
        <h2 class="text-xl font-bold text-orange-600 mb-4">
            Factures de <?php echo e($customer->name); ?>

        </h2>

        <?php if($invoices->isEmpty()): ?>
            <p class="text-gray-500">Aucune facture trouvée pour ce client.</p>
        <?php else: ?>
            <table class="w-full border border-gray-200 text-sm">
                <thead class="bg-gray-100">
                <tr>
                    <th class="border px-3 py-2">N° Facture</th>
                    <th class="border px-3 py-2">PO</th>
                    <th class="border px-3 py-2">Actions</th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="border px-3 py-2"><?php echo e($invoice->numero_invoice); ?></td>
                        <td class="border px-3 py-2"><?php echo e($invoice->po); ?></td>
                        <td class="border px-3 py-2">
                            <a href="<?php echo e(route('invoices.show', $invoice->id)); ?>"
                               class="text-orange-600 inline-flex items-center gap-1">
                                <i data-lucide="eye" class="w-4 h-4"></i> Voir
                            </a>
                        </td>

                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        <?php endif; ?>

        <a href="<?php echo e(route('customers.index')); ?>" class="mt-4 inline-block text-gray-600">
            ← Retour aux clients
        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/jeanluckawel/PhpstormProjects/KitServices/resources/views/invoices/list.blade.php ENDPATH**/ ?>