<?php $__env->startSection('title', 'Kit Service | Manage Functions'); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-4xl mx-auto mt-10 p-6 bg-white rounded shadow">


        <a href="<?php echo e(route('dashboard')); ?>" class="px-4 py-2 text-sm font-medium text-gray-500 hover:text-orange-600 hover:border-orange-600 border-b-2 border-transparent">
            Dashboard
        </a>
        <a  class="px-4  py-2 text-sm font-medium text-orange-600 border-b-2 border-orange-600">
            Functions
        </a>


        <h2 class="text-2xl mt-5 font-bold mb-6 text-orange-600">Manage Functions</h2>

        <!-- Tabs -->
        <div x-data="{ tab: 'add' }" class="mb-4">
            <nav class="flex border-b border-orange-200 mb-4">
                <button @click="tab = 'add'"
                        :class="tab === 'add' ? 'border-orange-600 text-orange-600' : 'text-gray-700'"
                        class="px-4 py-2 font-medium border-b-2">
                    Add Function
                </button>
                <button @click="tab = 'show'"
                        :class="tab === 'show' ? 'border-orange-600 text-orange-600' : 'text-gray-700'"
                        class="px-4 py-2 font-medium border-b-2">
                    Show Functions
                </button>
            </nav>

            <!-- Add Function Form -->
            <div x-show="tab === 'add'" x-transition>
                <?php if(session('success')): ?>
                    <div class="mb-4 px-4 py-2 bg-green-100 border border-green-300 text-green-700 rounded">
                        ✔️ <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                    <div class="mb-4 px-4 py-2 bg-red-100 border border-red-300 text-red-700 rounded">
                        ⚠️ <?php echo e($errors->first()); ?>

                    </div>
                <?php endif; ?>

                <form action="<?php echo e(route('functions.store')); ?>" method="POST" class="space-y-4">
                    <?php echo csrf_field(); ?>
                    <div>
                        <label class="block mb-2 text-orange-600 font-medium">Department</label>
                        <select name="department_id"
                                class="w-full border border-orange-300 px-3 py-2 rounded focus:ring-2 focus:ring-orange-400"
                                required>
                            <option value="">-- Select Department --</option>
                            <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($dept->id); ?>"><?php echo e($dept->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div>
                        <label class="block mb-2 text-orange-600 font-medium">Function Name</label>
                        <input type="text" name="name"
                               class="w-full border border-orange-300 px-3 py-2 rounded focus:ring-2 focus:ring-orange-400"
                               required>
                    </div>

                    <button type="submit"
                            class="bg-orange-600 hover:bg-orange-700 text-white px-4 py-2 rounded shadow">
                        Save
                    </button>
                </form>
            </div>

            <!-- Show Functions -->
            <div x-show="tab === 'show'" x-transition class="overflow-auto max-h-96 border border-orange-300 rounded">
                <table class="w-full border-collapse">
                    <thead class="bg-orange-100 sticky top-0 z-10">
                    <tr>
                        <th class="border px-4 py-2 text-left text-orange-600">#</th>
                        <th class="border px-4 py-2 text-left text-orange-600">Department</th>
                        <th class="border px-4 py-2 text-left text-orange-600">Function</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $counter = 1; ?>
                    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $deptFunctions = $functions->where('department_id', $dept->id);
                            $rowspan = $deptFunctions->count();
                            $first = true;
                        ?>

                        <?php $__currentLoopData = $deptFunctions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $func): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover:bg-orange-50">
                                <?php if($first): ?>
                                    <td class="border px-4 py-2" rowspan="<?php echo e($rowspan); ?>">
                                        <?php echo e($counter++); ?>

                                    </td>
                                    <td class="border px-4 py-2" rowspan="<?php echo e($rowspan); ?>">
                                        <?php echo e($dept->name); ?>

                                    </td>
                                    <?php $first = false; ?>
                                <?php endif; ?>

                                <td class="border px-4 py-2"><?php echo e($func->name); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/jeanluckawel/PhpstormProjects/KitServices/resources/views/fonction/create.blade.php ENDPATH**/ ?>