<?php $__env->startSection('title', 'Kit Service | Employee Card'); ?>

<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet" />
<link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
<script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
<script src="https://cdn.jsdelivr.net/npm/@tailwindcss/browser@4"></script>

<?php $__env->startSection('content'); ?>
    <div class="max-w-6xl mx-auto mt-10 bg-white p-6 rounded-lg shadow-sm" x-data="{ open: false, selectedEmployee: null }">

        <!-- Header fixe -->
        <div class="sticky top-0 bg-white z-10 pb-4 mb-4">
            <!-- Navigation -->
            <div class="flex space-x-4 mb-4">
                <a href="<?php echo e(route('dashboard')); ?>" class="px-4 py-2 text-sm font-medium text-gray-500 hover:text-orange-600 hover:border-orange-600 border-b-2 border-transparent">
                    Dashboard
                </a>
                <span class="px-4 py-2 text-sm font-medium text-orange-600 border-b-2 border-orange-600">
                Employee Card
            </span>
            </div>

            <h2 class="text-2xl font-bold mb-4 text-orange-600">Employee Card</h2>

        <!-- Grid des cartes avec scroll si besoin -->
            <!-- Grid des cartes avec scroll si besoin -->
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6 justify-center overflow-y-auto max-h-[calc(100vh-200px)]">
                <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="w-[220px] bg-white rounded-xl shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300">

                        <!-- Photo de l'employé -->
                        <div class="w-full h-40 bg-gray-100 flex items-center justify-center overflow-hidden">
                            <?php
                                $gender = strtolower($employee->gender);

                                if ($gender === 'female') {
                                    $photoPath = 'assets/profil/female.png';
                                } elseif ($gender === 'male') {
                                    $photoPath = 'assets/profil/male.png';
                                } else {
                                    $photoPath = 'assets/profil/other.png';
                                }
                            ?>


                            <img
                                src="<?php echo e(asset($photoPath)); ?>"

                                alt="<?php echo e($employee->first_name); ?>"
                                class="max-h-full max-w-full object-contain"
                            />
                        </div>

                        <!-- Infos -->
                        <div class="p-4 text-center">
                            <h3 class="text-sm font-bold text-gray-800 truncate"><?php echo e($employee->first_name); ?> <?php echo e($employee->last_name); ?></h3>
                            <p class="text-[11px] text-gray-500 mb-2">ID: <?php echo e($employee->employee_id); ?></p>

                            <div class="text-left text-gray-600 text-[11px] space-y-1 mb-3">
                                <p><strong>Department:</strong> <?php echo e($employee->department); ?></p>
                                <p><strong>Function:</strong> <?php echo e($employee->function); ?></p>
                                <p><strong>Date d'embauche:</strong> <?php echo e($employee->created_at->format('d M Y')); ?></p>
                            </div>

                            <!-- Buttons -->
                            <div class="flex justify-center gap-2 mt-2 flex-wrap">
                                <a href="<?php echo e(route('employees.edit', $employee->employee_id)); ?>"
                                   class="px-3 py-1 bg-orange-500 text-white text-sm rounded hover:bg-orange-600 transition">Edit
                                </a>

                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/jeanluckawel/PhpstormProjects/KitServices/resources/views/employees/card.blade.php ENDPATH**/ ?>