<?php $__env->startSection('content'); ?>
    <div class="max-w-4xl mx-auto mt-10 p-6 bg-white rounded shadow">


        <a href="<?php echo e(route('dashboard')); ?>" class="px-4 py-2 text-sm font-medium text-gray-500 hover:text-orange-600 hover:border-orange-600 border-b-2 border-transparent">
            Dashboard
        </a>
        <a  class="px-4  py-2 text-sm font-medium text-orange-600 border-b-2 border-orange-600">
            Functions
        </a>


        <h2 class="text-2xl mt-5 font-bold mb-6 text-orange-600">Manage Niveaux</h2>

        <!-- Tabs -->
        <div x-data="{ tab: 'add' }" class="mb-4">
            <nav class="flex border-b border-orange-200 mb-4">
                <button @click="tab = 'add'"
                        :class="tab === 'add' ? 'border-orange-600 text-orange-600' : 'text-gray-700'"
                        class="px-4 py-2 font-medium border-b-2">
                    Add Niveau
                </button>
                <button @click="tab = 'show'"
                        :class="tab === 'show' ? 'border-orange-600 text-orange-600' : 'text-gray-700'"
                        class="px-4 py-2 font-medium border-b-2">
                    Show Niveaux
                </button>
            </nav>

            <!-- Add Niveau Form -->
            <div x-show="tab === 'add'" x-transition>
                <!-- Message de succès -->
                <?php if(session('success')): ?>
                    <div class="mb-4 bg-green-100 text-green-800 p-3 rounded font-semibold">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <!-- Message d'erreur -->
                <?php if($errors->any()): ?>
                    <div class="mb-4 bg-red-100 text-red-800 p-3 rounded font-semibold">
                        <?php echo e($errors->first('name')); ?>

                    </div>
                <?php endif; ?>

                <form action="<?php echo e(route('niveaux.store')); ?>" method="POST" class="space-y-4">
                    <?php echo csrf_field(); ?>
                    <div>
                        <label class="block mb-2 text-orange-600 font-medium">Niveau Name</label>
                        <input type="text" name="name"
                               class="w-full border border-orange-300 px-3 py-2 rounded focus:ring-2 focus:ring-orange-400"
                               required>
                    </div>

                    <button type="submit" class="bg-orange-600 hover:bg-orange-700 text-white px-4 py-2 rounded">
                        Save
                    </button>
                </form>
            </div>

            <!-- Show Niveaux -->
            <div x-show="tab === 'show'" x-transition
                 class="overflow-auto max-h-96 border border-orange-300 rounded">
                <table class="w-full border-collapse">
                    <thead class="bg-orange-100 sticky top-0 z-10">
                    <tr>
                        <th class="border px-4 py-2 text-left text-orange-600">#</th>
                        <th class="border px-4 py-2 text-left text-orange-600">Niveau</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $niveaux; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $niveau): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="hover:bg-orange-50">
                            <td class="border px-4 py-2"><?php echo e($niveau->id); ?></td>
                            <td class="border px-4 py-2"><?php echo e($niveau->name); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/jeanluckawel/PhpstormProjects/KitServices/resources/views/niveau/create.blade.php ENDPATH**/ ?>