<?php $__env->startSection('title', 'Kit Service | Grille Salariale'); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-6xl mx-auto mt-10 bg-white p-6 rounded-xl shadow-lg" x-data="{ tab: 'add' }">


        <a href="<?php echo e(route('dashboard')); ?>" class="px-4 py-2 text-sm font-medium text-gray-500 hover:text-orange-600 hover:border-orange-600 border-b-2 border-transparent">
            Dashboard
        </a>
        <a  class="px-4 py-2 text-sm font-medium text-orange-600 border-b-2 border-orange-600">
            Grille Salariale
        </a>

        <h2 class="text-2xl font-bold text-orange-600 mt-5 mb-6">Gestion Grille Salariale</h2>

        <!-- Onglets -->
        <nav class="flex border-b border-orange-200 mb-6">
            <button @click="tab = 'add'"
                    :class="tab === 'add' ? 'border-orange-600 text-orange-600' : 'text-gray-700'"
                    class="px-4 py-2 font-medium border-b-2">
                ➕ Ajouter
            </button>
            <button @click="tab = 'show'"
                    :class="tab === 'show' ? 'border-orange-600 text-orange-600' : 'text-gray-700'"
                    class="px-4 py-2 font-medium border-b-2">
                📋 Liste
            </button>
        </nav>

        <!-- Add Grille -->
        <div x-show="tab === 'add'" x-transition>
            <!-- Message succès -->
            <?php if(session('success')): ?>
                <div class="bg-green-100 text-green-800 p-3 rounded mb-4">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <!-- Message d'erreur -->
            <?php if($errors->any()): ?>
                <div class="mb-4 bg-red-100 text-red-800 p-3 rounded font-semibold">
                    <?php if($errors->has('duplicate')): ?>
                        <?php echo e($errors->first('duplicate')); ?>

                    <?php else: ?>
                        <?php echo e($errors->first()); ?>

                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('salary_grids.store')); ?>" class="space-y-6">
                <?php echo csrf_field(); ?>

                <!-- Department -->
                <div>
                    <label class="block mb-2 text-orange-600 font-medium">Department</label>
                    <select id="department" name="department_id"
                            class="w-full border border-orange-300 px-3 py-2 rounded focus:ring-2 focus:ring-orange-400" required>
                        <option value="">-- Select Department --</option>
                        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($dept->id); ?>"><?php echo e($dept->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Fonction -->
                <div>
                    <label class="block mb-2 text-orange-600 font-medium">Fonction</label>
                    <select id="fonction" name="fonction_id"
                            class="w-full border border-orange-300 px-3 py-2 rounded focus:ring-2 focus:ring-orange-400" required>
                        <option value="">-- Select Fonction --</option>
                    </select>
                </div>

                <!-- Niveau -->
                <div>
                    <label class="block mb-2 text-orange-600 font-medium">Niveau</label>
                    <select id="niveau" name="niveau_id"
                            class="w-full border border-orange-300 px-3 py-2 rounded focus:ring-2 focus:ring-orange-400" required>
                        <option value="">-- Select Niveau --</option>
                        <?php $__currentLoopData = $niveaux; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $niveau): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($niveau->id); ?>"><?php echo e($niveau->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Échelon -->
                <div>
                    <label class="block mb-2 text-orange-600 font-medium">Échelon</label>
                    <select id="echelon" name="echelon_id"
                            class="w-full border border-orange-300 px-3 py-2 rounded focus:ring-2 focus:ring-orange-400" required>
                        <option value="">-- Select Échelon --</option>
                    </select>
                </div>

                <!-- Salaire -->






                <button type="submit"
                        class="bg-orange-500 hover:bg-orange-600 text-white font-bold px-6 py-2 rounded-lg shadow">
                    Enregistrer
                </button>
            </form>
        </div>

        <!-- Show Grilles -->
        <div x-show="tab === 'show'" x-transition>
            <div class="overflow-auto max-h-96 border border-orange-300 rounded mt-4">
                <table class="w-full border-collapse">
                    <thead class="bg-orange-100 sticky top-0 z-10">
                    <tr>
                        <th class="border px-4 py-2 text-left text-orange-600">ID</th>
                        <th class="border px-4 py-2 text-left text-orange-600">Department</th>
                        <th class="border px-4 py-2 text-left text-orange-600">Fonction</th>
                        <th class="border px-4 py-2 text-left text-orange-600">Niveau</th>
                        <th class="border px-4 py-2 text-left text-orange-600">Échelon</th>

                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $salaryGrids; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grid): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="hover:bg-orange-50">
                            <td class="border px-4 py-2"><?php echo e($grid->id); ?></td>
                            <td class="border px-4 py-2"><?php echo e($grid->department->name); ?></td>
                            <td class="border px-4 py-2"><?php echo e($grid->fonction->name); ?></td>
                            <td class="border px-4 py-2"><?php echo e($grid->niveau->name); ?></td>
                            <td class="border px-4 py-2"><?php echo e($grid->echelon->name); ?></td>
                           <td class="border px-4 py-2 font-semibold text-gray-700" ><?php echo e(number_format($grid->base_salary, 2, ',', ' ')); ?> $</td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Script pour dropdowns dynamiques -->
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let departmentSelect = document.getElementById("department");
            let fonctionSelect = document.getElementById("fonction");
            let niveauSelect = document.getElementById("niveau");
            let echelonSelect = document.getElementById("echelon");

            // Fonction dynamique
            departmentSelect.addEventListener("change", function() {
                let departmentId = this.value;
                fonctionSelect.innerHTML = '<option value="">-- Select Fonction --</option>';
                if (departmentId) {
                    fetch(`/departments/${departmentId}/functions`)
                        .then(res => res.json())
                        .then(data => {
                            data.forEach(func => {
                                let option = document.createElement("option");
                                option.value = func.id;
                                option.textContent = func.name;
                                fonctionSelect.appendChild(option);
                            });
                        });
                }
            });

            // Échelon dynamique
            niveauSelect.addEventListener("change", function() {
                let niveauId = this.value;
                echelonSelect.innerHTML = '<option value="">-- Select Échelon --</option>';
                if (niveauId) {
                    fetch(`/niveaux/${niveauId}/echelons`)
                        .then(res => res.json())
                        .then(data => {
                            data.forEach(ech => {
                                let option = document.createElement("option");
                                option.value = ech.id;
                                option.textContent = ech.name;
                                echelonSelect.appendChild(option);
                            });
                        });
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/jeanluckawel/PhpstormProjects/KitServices/resources/views/salary_grids/create.blade.php ENDPATH**/ ?>