<?php

namespace Database\Seeders;

use App\Models\Customer;
use Illuminate\Database\Seeder;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;

class CustomerSeeder extends Seeder
{
    public function run(): void
    {
        $clients = [
            [
                'name' => 'KAMOA COPPER SA',
                'id_nat' => '05-B0500-N37233J',
                'rccm' => '14-B-1683',
                'nif' => 'A0901048A',
                'province' => 'Lualaba',
                'ville' => 'Kolwezi',
                'commune' => 'Manika',
                'quartier' => 'Joli-Site',
                'avenue' => 'Route Likasi',
                'numero' => '999',
                'telephone' => '+243996072600',
                'email' => 'communications@kamoacopper.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'TENKE FUNGURUME MINING SA',
                'id_nat' => '06-B1200-N58221K',
                'rccm' => '15-B-2251',
                'nif' => 'B0902033B',
                'province' => 'Lualaba',
                'ville' => 'Kolwezi',
                'commune' => 'Dilala',
                'quartier' => 'Kasulo',
                'avenue' => 'Avenue Industrielle',
                'numero' => '450',
                'telephone' => '+243977000111',
                'email' => 'contact@tfm.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'MUTANDA MINING SARL',
                'id_nat' => '04-B2200-N33211H',
                'rccm' => '13-B-1456',
                'nif' => 'C0904044C',
                'province' => 'Lualaba',
                'ville' => 'Kolwezi',
                'commune' => 'Manika',
                'quartier' => 'Kapata',
                'avenue' => 'Route Likasi',
                'numero' => '210',
                'telephone' => '+243977000222',
                'email' => 'info@mutanda.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'KIBALI GOLDMINES SA',
                'id_nat' => '07-B3300-N84255L',
                'rccm' => '16-B-2880',
                'nif' => 'D0905055D',
                'province' => 'Haut-Uélé',
                'ville' => 'Durba',
                'commune' => 'Watsa',
                'quartier' => 'Durba Centre',
                'avenue' => 'Boulevard Minier',
                'numero' => '100',
                'telephone' => '+243977000333',
                'email' => 'admin@kibali.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'CHEMAF SA',
                'id_nat' => '03-B1100-N27566F',
                'rccm' => '12-B-1123',
                'nif' => 'E0906066E',
                'province' => 'Haut-Katanga',
                'ville' => 'Lubumbashi',
                'commune' => 'Kamalondo',
                'quartier' => 'Kalubwe',
                'avenue' => 'Avenue de la Paix',
                'numero' => '22',
                'telephone' => '+243977000444',
                'email' => 'contact@chemaf.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'KCC (KAMOTO COPPER COMPANY)',
                'id_nat' => '05-B4400-N29344K',
                'rccm' => '14-B-1950',
                'nif' => 'F0907077F',
                'province' => 'Lualaba',
                'ville' => 'Kolwezi',
                'commune' => 'Manika',
                'quartier' => 'Kapata',
                'avenue' => 'Route Kamoto',
                'numero' => '88',
                'telephone' => '+243977000555',
                'email' => 'support@kcc.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'SICOMINES SA',
                'id_nat' => '09-B5500-N91222M',
                'rccm' => '17-B-3102',
                'nif' => 'G0908088G',
                'province' => 'Haut-Katanga',
                'ville' => 'Lubumbashi',
                'commune' => 'Annexe',
                'quartier' => 'Golf',
                'avenue' => 'Route Kasumbalesa',
                'numero' => '777',
                'telephone' => '+243977000666',
                'email' => 'info@sicomines.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'MOPANI DRILLING SARL',
                'id_nat' => '08-B6600-N12890N',
                'rccm' => '18-B-3333',
                'nif' => 'H0909099H',
                'province' => 'Lualaba',
                'ville' => 'Kolwezi',
                'commune' => 'Dilala',
                'quartier' => 'Kasapa',
                'avenue' => 'Avenue Industrielle',
                'numero' => '300',
                'telephone' => '+243977000777',
                'email' => 'contact@mopani.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'SOMIKA SA',
                'id_nat' => '10-B7700-N22881P',
                'rccm' => '19-B-3500',
                'nif' => 'I0910101I',
                'province' => 'Haut-Katanga',
                'ville' => 'Lubumbashi',
                'commune' => 'Kenya',
                'quartier' => 'Kasapa',
                'avenue' => 'Avenue Industrielle',
                'numero' => '55',
                'telephone' => '+243977000888',
                'email' => 'info@somika.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'ERG AFRICA',
                'id_nat' => '11-B8800-N55432Q',
                'rccm' => '20-B-3700',
                'nif' => 'J0911111J',
                'province' => 'Lualaba',
                'ville' => 'Kolwezi',
                'commune' => 'Manika',
                'quartier' => 'Kapata',
                'avenue' => 'Route Kasulo',
                'numero' => '123',
                'telephone' => '+243977000999',
                'email' => 'contact@ergafrica.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            // 👉 ajoute encore 10 fictifs pour atteindre 20
            [
                'name' => 'AFRICAN MINERALS SARL',
                'id_nat' => '12-B9900-N66111R',
                'rccm' => '21-B-4001',
                'nif' => 'K0912121K',
                'province' => 'Kinshasa',
                'ville' => 'Kinshasa',
                'commune' => 'Gombe',
                'quartier' => 'Résidentiel',
                'avenue' => 'Boulevard du 30 Juin',
                'numero' => '12',
                'telephone' => '+243977001000',
                'email' => 'admin@africanminerals.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'MINES CONGO SARL',
                'id_nat' => '13-B1000-N77123S',
                'rccm' => '22-B-4205',
                'nif' => 'L0913131L',
                'province' => 'Haut-Katanga',
                'ville' => 'Lubumbashi',
                'commune' => 'Annexe',
                'quartier' => 'Kamalondo',
                'avenue' => 'Avenue du Marché',
                'numero' => '77',
                'telephone' => '+243977001111',
                'email' => 'contact@minescongo.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'GLOBAL RESOURCES DRC',
                'id_nat' => '14-B1111-N88144T',
                'rccm' => '23-B-4502',
                'nif' => 'M0914141M',
                'province' => 'Kinshasa',
                'ville' => 'Kinshasa',
                'commune' => 'Ngaliema',
                'quartier' => 'Binza',
                'avenue' => 'Avenue Nguma',
                'numero' => '56',
                'telephone' => '+243977001222',
                'email' => 'info@globalres.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'BARRICK CONGO SA',
                'id_nat' => '15-B1222-N99155U',
                'rccm' => '24-B-4780',
                'nif' => 'N0915151N',
                'province' => 'Ituri',
                'ville' => 'Bunia',
                'commune' => 'Shari',
                'quartier' => 'Kilo',
                'avenue' => 'Avenue des Mines',
                'numero' => '05',
                'telephone' => '+243977001333',
                'email' => 'admin@barrickcongo.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'MINERAL TRADING DRC',
                'id_nat' => '16-B1333-N00266V',
                'rccm' => '25-B-4900',
                'nif' => 'O0916161O',
                'province' => 'Nord-Kivu',
                'ville' => 'Goma',
                'commune' => 'Goma',
                'quartier' => 'Katindo',
                'avenue' => 'Avenue du Lac',
                'numero' => '19',
                'telephone' => '+243977001444',
                'email' => 'contact@mineraltrading.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'DRC ENERGY SARL',
                'id_nat' => '17-B1444-N11377W',
                'rccm' => '26-B-5100',
                'nif' => 'P0917171P',
                'province' => 'Kinshasa',
                'ville' => 'Kinshasa',
                'commune' => 'Gombe',
                'quartier' => 'Commercial',
                'avenue' => 'Avenue de la Justice',
                'numero' => '34',
                'telephone' => '+243977001555',
                'email' => 'support@drcenergy.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'CONGO EXPORT SARL',
                'id_nat' => '18-B1555-N22488X',
                'rccm' => '27-B-5301',
                'nif' => 'Q0918181Q',
                'province' => 'Bas-Uélé',
                'ville' => 'Buta',
                'commune' => 'Buta',
                'quartier' => 'Centre',
                'avenue' => 'Avenue de l’Indépendance',
                'numero' => '70',
                'telephone' => '+243977001666',
                'email' => 'info@congoexport.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'KIN MINING SARL',
                'id_nat' => '19-B1666-N33599Y',
                'rccm' => '28-B-5500',
                'nif' => 'R0919191R',
                'province' => 'Kinshasa',
                'ville' => 'Kinshasa',
                'commune' => 'Limete',
                'quartier' => 'Industriel',
                'avenue' => 'Boulevard Lumumba',
                'numero' => '200',
                'telephone' => '+243977001777',
                'email' => 'admin@kinmining.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'AFRICAN TRADING COMPANY',
                'id_nat' => '20-B1777-N44700Z',
                'rccm' => '29-B-5700',
                'nif' => 'S0920202S',
                'province' => 'Sud-Kivu',
                'ville' => 'Bukavu',
                'commune' => 'Ibanda',
                'quartier' => 'Nguba',
                'avenue' => 'Avenue Patrice Lumumba',
                'numero' => '17',
                'telephone' => '+243977001888',
                'email' => 'info@africantrading.com',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ];

        DB::table('customers')->insert($clients);
    }
}
